//scilab 5.5.2 , OS: Ubuntu 14.04
//Program To Design the Digtial Butterworth  IIR Filter 
//Design a digital IIR low pass filter with following specifications.
//a) Pass band cut-off frequency     :1000 Hz
//b) Pass band ripple                       :-1 dB
//c) Stop band cut-off frequency     :3000 Hz
//d) Stop band attenuation               : -15 dB
//Sampling frequency: 15000 Hz

clear all;clc;close;
f1=1000;//input('Enter the pass band edge(Hz)= ');
f2=3000;//input('Enter the stop band edge(Hz)= ');
k1=-1;//input('Enter the pass band attenuation(dB)= ');
k2=-15;//input('Enter the stop band attenuation(dB)= ');
fs=10000;//input('Enter the sampling rate(Hz)= ');

//Digital filter specifications(rad)
w1=2*%pi*f1*1/fs;
w2=2*%pi*f2*1/fs;

//Pre warping
o1=2*fs*tan(w1/2)
o2=2*fs*tan(w2/2)

//Design of analog filter
n=log10(((10.^(-k1/10))-1)/((10.^(-k2/10))-1))./(2*log10(o1/o2));
n=round(n);
wn= o2./((10.^(-k2/10)-1).^(1/(2*n)));

//[h,poles,zeros,gain]=analpf(n,'butt',[0 0],wn)hb.dt = 'c';
//[fr,hr]=repfreq(hb,fmin,fmax)

h=buttmag(n,wn,1:2*%pi*fs);
mag=20*log10(h)';


//Converting analog to digital filter 
hz=iir(n,'lp','butt',0.25,[])
//g*poly(z,'z')/poly(p,'z')

[hzm,fr]=frmag(hz,256);
magz=20*log10(hzm)';

subplot(2,1,1),plot2d((1:2*%pi*fs)',mag),xtitle('Analog IIR filter: lowpass','Analog frequency in rads/sec', 'dB',' ');subplot(2,1,2),plot2d(fr,magz);xtitle('Digital IIR filter: lowpass 0 < fr < 0.5','frequency', 'dB',' ');

//note: Use zoom/axis commands to verify the design.
